/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.cec;

import com.quantumdata.cec.CheckBoxNode;
import com.quantumdata.widgets.QDCheckBox;
import com.quantumdata.widgets.QDStdUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;

class CheckBoxNodeRenderer
implements TreeCellRenderer {
    private QDCheckBox leafRenderer = new QDCheckBox();
    private DefaultTreeCellRenderer nonLeafRenderer = new DefaultTreeCellRenderer();
    Color selectionBorderColor;
    Color selectionForeground;
    Color selectionBackground;
    Color textForeground;
    Color textBackground;

    protected QDCheckBox getLeafRenderer() {
        return this.leafRenderer;
    }

    public CheckBoxNodeRenderer() {
        Boolean bl;
        Font font = UIManager.getFont("Tree.font");
        if (font != null) {
            this.leafRenderer.setFont(font);
        }
        this.leafRenderer.setFocusPainted((bl = (Boolean)UIManager.get("Tree.drawsFocusBorderAroundIcon")) != null && bl != false);
        this.selectionBorderColor = QDStdUI.getBorderColor();
        this.selectionForeground = QDStdUI.getForeground();
        this.selectionBackground = QDStdUI.getBackground();
        this.textForeground = QDStdUI.getActionForeground();
        this.textBackground = QDStdUI.getActionBackground();
        this.nonLeafRenderer.setBackground(QDStdUI.getBackground());
        this.nonLeafRenderer.setBackgroundNonSelectionColor(QDStdUI.getActionBackground());
        this.nonLeafRenderer.setBackgroundSelectionColor(QDStdUI.getBackground());
        this.nonLeafRenderer.setTextNonSelectionColor(QDStdUI.getForeground());
        this.nonLeafRenderer.setTextSelectionColor(QDStdUI.getActionForeground());
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        Component component;
        if (bl3) {
            Object object2;
            String string = jTree.convertValueToText(object, bl, bl2, bl3, n, false);
            this.leafRenderer.setText(string);
            this.leafRenderer.setSelected(false);
            this.leafRenderer.setEnabled(jTree.isEnabled());
            if (bl) {
                this.leafRenderer.setForeground(this.selectionForeground);
                this.leafRenderer.setBackground(this.selectionBackground);
            } else {
                this.leafRenderer.setForeground(this.textForeground);
                this.leafRenderer.setBackground(this.textBackground);
            }
            if (object != null && object instanceof DefaultMutableTreeNode && (object2 = ((DefaultMutableTreeNode)object).getUserObject()) instanceof CheckBoxNode) {
                CheckBoxNode checkBoxNode = (CheckBoxNode)object2;
                this.leafRenderer.setText(checkBoxNode.getText());
                this.leafRenderer.setSelected(checkBoxNode.isSelected());
            }
            component = this.leafRenderer;
        } else {
            component = this.nonLeafRenderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        }
        return component;
    }
}

